<?php
include_once('models/order-details.class.php');

class ResOrders
{
    public $id;
    public $order_id;
    public $table_id;
    public $total_amount;
    public $special_request;
    public $order_status_id;

    public function __construct($_id, $_order_id, $_table_id, $_total_amount, $_special_request, $_order_status_id)
    {
        $this->id = $_id;
        $this->order_id = $_order_id;
        $this->table_id = $_table_id;
        $this->total_amount = $_total_amount;
        $this->special_request = $_special_request;
        $this->order_status_id = $_order_status_id;
    }

    // Create a new order
    public function create()
    {
        global $db;
        $sql = "INSERT INTO res_orders (id, table_id, total_amount, special_request, order_status_id) 
                VALUES ('{$this->id}', '{$this->table_id}', '{$this->total_amount}', '{$this->special_request}', '{$this->order_status_id}')";
        if ($db->query($sql)) {
            return $db->insert_id;
        } else {
            return "Query failed: " . $db->error;
        }
    }

    // Create order along with items
    public function createOrder($items)
    {
        global $db;

        $sql = "INSERT INTO res_orders (table_id, total_amount, special_request, order_status_id) 
                VALUES ('{$this->table_id}', '{$this->total_amount}', '{$this->special_request}', '{$this->order_status_id}')";

        if ($db->query($sql)) {
            $order_id = $db->insert_id;

            foreach ($items as $item) {
                $order_details = new ResOrderDetails(
                    null,          
                    $order_id,    
                    $item->id,    
                    $item->quantity,
                    $item->price
                );

                $res = $order_details->create();
                if (!is_int($res)) {
                    return "Error saving order details: " . $res;
                }
            }

            return "Order Placed Successfully";
        } else {
            return "Error saving order: " . $db->error;
        }
    }

   
    public static function readAll()
    {
        global $db;
$sql = "SELECT o.*, t.name AS table_name, os.name AS order_status
        FROM res_orders o
        JOIN res_tables t ON o.table_id = t.id
        JOIN res_order_status os ON o.order_status_id = os.id
        ORDER BY o.id DESC";

        $res = $db->query($sql);
        return $res ? $res->fetch_all(MYSQLI_ASSOC) : [];
    }

    public static function readById($id)
    {
        global $db;
        $id = (int) $id;

        $orderSql = "SELECT o.id, o.total_amount, o.special_request, 
                            t.name AS table_name, os.name AS order_status
                     FROM res_orders o
                     JOIN res_tables t ON o.table_id = t.id
                     JOIN res_order_status os ON o.order_status_id = os.id
                     WHERE o.id = $id";
        $orderRes = $db->query($orderSql);
        $order = $orderRes ? $orderRes->fetch_assoc() : null;

        $itemsSql = "SELECT m.name AS menu_name, d.quantity, d.sub_total AS price
                     FROM res_order_details d
                     JOIN res_menu m ON d.menu_id = m.id
                     WHERE d.order_id = $id";
        $itemsRes = $db->query($itemsSql);
        $items = $itemsRes ? $itemsRes->fetch_all(MYSQLI_ASSOC) : [];

        return [
            "order" => $order,
            "items" => $items
        ];
    }

    public function update($id)
    {
        global $db;
        $sql = "UPDATE res_orders SET table_id='{$this->table_id}', total_amount='{$this->total_amount}', 
                special_request='{$this->special_request}', order_status_id='{$this->order_status_id}' 
                WHERE id = $id";
        if ($db->query($sql)) {
            return $db->affected_rows > 0 ? "Update successful." : "No changes made or record not found.";
        } else {
            return "Update failed: " . $db->error;
        }
    }

    public static function delete($id)
    {
        global $db;
        $sql = "DELETE FROM res_orders WHERE id = $id";
        if ($db->query($sql)) {
            return $db->affected_rows > 0 ? "Delete successful." : "No record found with ID $id.";
        } else {
            return "Delete failed: " . $db->error;
        }
    }
}
?>
