<?php
// Make sure session is started
if(!isset($_SESSION)) session_start();
$role_id = $_SESSION['role_id'] ?? 0; // Default to 0 if not set
?>

<div class="sidebar pe-4 pb-3">
    <nav class="navbar bg-secondary navbar-dark">
        <a href="dashboard" class="navbar-brand d-flex ms-3 w-100">
            <img src="img/logo.png" alt="ai_dine logo" style="height:100px; width:auto;">
        </a>

        <div class="d-flex align-items-center ms-4 mb-4">
            <div class="position-relative">
                <img class="rounded-circle" src="img/user.png" alt="" style="width: 40px; height: 40px;">
                <div class="bg-success rounded-circle border border-2 border-white position-absolute end-0 bottom-0 p-1"></div>
            </div>
            <div class="ms-3">
                <h6 class="mb-0"><?php echo $_SESSION['name'] ?? "User"; ?></h6>
                <span><?php echo $role_id == 1 ? "Admin" : "Waiter"; ?></span>
            </div>
        </div>

        <div class="navbar-nav w-100">
            <?php if($role_id == 1): // Admin menu ?>
                <a href="dashboard" class="nav-item nav-link"><i class="fa fa-tachometer-alt me-2"></i>Dashboard</a>
                <a href="roles" class="nav-item nav-link"><i class="fas fa-user-tie me-2"></i>Roles</a>
                <a href="users" class="nav-item nav-link"><i class="fas fa-users"></i>Users</a>
                <a href="menu" class="nav-item nav-link"><i class="fas fa-utensils"></i>Menu</a>
                <a href="tables" class="nav-item nav-link"><i class="fas fa-chair"></i>Tables</a>
                <a href="orders" class="nav-item nav-link"><i class="fas fa-clipboard-list" style="color: #B197FC;"></i>Orders</a>
                <a href="online-orders" class="nav-item nav-link"> <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#A7C4E5"><path d="M160-120q-33 0-56.5-23.5T80-200v-440q0-33 23.5-56.5T160-720h160v-80q0-33 23.5-56.5T400-880h160q33 0 56.5 23.5T640-800v80h160q33 0 56.5 23.5T880-640v440q0 33-23.5 56.5T800-120H160Zm0-80h160v-120q-26-6-43-27.5T260-397v-163h40v151h30v-151h40v151h30v-151h40v163q0 28-17 49.5T380-320v120h200v-88q-26-15-43-50.5T520-420q0-58 26-99t64-41q37 0 63.5 41t26.5 99q0 47-17 82.5T640-288v88h160v-440H160v440Zm240-520h160v-80H400v80ZM160-200v-440 440Z"/></svg> Online Orders</a>
                <a href="reservations" class="nav-item nav-link"><svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#A7C4E5"><path d="M200-80q-33 0-56.5-23.5T120-160v-560q0-33 23.5-56.5T200-800h40v-80h80v80h320v-80h80v80h40q33 0 56.5 23.5T840-720v255l-80 80v-175H200v400h248l80 80H200Zm0-560h560v-80H200v80Zm0 0v-80 80ZM662-60 520-202l56-56 85 85 170-170 56 57L662-60Z"/></svg> Reservations</a>
            <?php elseif($role_id == 8): // Waiter menu ?>
                <a href="menu" class="nav-item nav-link"><i class="fas fa-utensils"></i>Menu</a>
                <a href="tables" class="nav-item nav-link"><i class="fas fa-chair" style="color: #e80005;"></i>Tables</a>
            <?php endif; ?>


        </div>
    </nav>
</div>
