<?php
require_once("models/res_order.class.php");

if (!isset($_GET["id"])) {
    die("Order ID not specified.");
}

$data = ResOrders::readById($_GET["id"]);
$order = $data["order"];
$items = $data["items"];

if (!$order) {
    die("Order not found.");
}
?>

<!-- Invoice Start -->
<div class="container invoice-page">
    <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
        <div class="col-12 col-sm-8 col-md-6 col-lg-5 col-xl-6">
            <div class="bg-white rounded p-4 my-4 mx-3 text-center reciept" style="font-family: monospace;">

                <!-- Logo -->
                <div class="mb-0">
                    <img src="img/logo.png" alt="Logo" class="img-fluid" style="max-width:120px; height:auto;">
                    <p class="mb-0 small-text"><i class="fas fa-map-pin"></i> 123/B Dhaka-1100</p>
                    <p class="mb-0 small-text"><i class="fas fa-phone"></i> 012345678910</p>
                </div>

                <!-- Invoice Details -->
                <div class="form-floating mb-1">
                    <input type="text" class="form-control bg-white text-dark border-0 shadow-none" 
                           id="invoiceId" value="INV-<?php echo $order['id']; ?>" readonly>
                    <label for="invoiceId">Invoice ID</label>
                </div>

                <div class="form-floating mb-1">
                    <input type="text" class="form-control bg-white text-dark border-0 shadow-none" 
                           id="tableName" value="<?php echo $order['table_name']; ?>" readonly>
                    <label for="tableName">Table Name</label>
                </div>

                <div class="form-floating mb-1">
                    <input type="text" class="form-control bg-white text-dark border-0 shadow-none" 
                           id="invoiceDate" value="<?php echo date("Y-m-d"); ?>" readonly>
                    <label for="invoiceDate">Invoice Date</label>
                </div>

                <!-- Order Items -->
                <table class="table text-start" style="table-layout: fixed; width: 100%;">
                    <thead>
                        <tr>
                            <th>Item</th>
                            <th>Quantity</th>
                            <th>Price</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($items as $item): ?>
                            <tr>
                                <td><?php echo $item['menu_name']; ?></td>
                                <td><?php echo $item['quantity']; ?></td>
                                <td>৳<?php echo $item['price']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Total</th>
                            <th></th>
                            <th>৳<?php echo $order['total_amount']; ?></th>
                        </tr>
                    </tfoot>
                </table>

                <!-- Print Button -->
                <button class="btn btn-primary py-3 w-100 mb-4 print-btn" onclick="window.print()">
                    Print Invoice
                </button>

                <hr>
                <p class="mt-4">THANK YOU FOR DINING WITH US!</p>
            </div>
        </div>
    </div>
</div>
<!-- Invoice End -->

<!-- Print CSS -->
<style>
.small-text { font-size: 0.8rem; }

@media print {
    @page {
        size: B5;        
    }

    body * {
        visibility: hidden;
    }

    .reciept {
        visibility: visible !important;
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: auto;
        overflow: visible;
        font-size: 12px;
    }

    .reciept * {
        visibility: visible !important;
    }

    .print-btn {
        display: none !important;
    }

    table {
        page-break-inside: avoid;
    }

    tr, td, th {
        page-break-inside: avoid;
    }
}



</style>
