<?php
require_once("config/db.php"); // Include your database connection

$error = '';

if (isset($_POST['email'], $_POST['password'])) {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    // Prepare statement to prevent SQL injection
    $stmt = $db->prepare("SELECT id, password, role_id, name FROM res_users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $stmt->bind_result($userId, $hashedPassword, $roleId, $userName);
        $stmt->fetch();

        if (password_verify($password, $hashedPassword)) {
            // Login successful
            $_SESSION['userId'] = $userId;
            $_SESSION['role_id'] = $roleId;
            $_SESSION['name'] = $userName;

            // Redirect based on role
            if ($roleId == 1) { // Admin
                header("Location:".ADMIN_BASE."dashboard");
            } elseif ($roleId == 8) { // Waiter
                header("Location:".ADMIN_BASE."menu"); // Start page for waiter
            } else {
                header("Location:".ADMIN_BASE."dashboard"); // fallback
            }
            exit();
        } else {
            $error = "Invalid password.";
        }
    } else {
        $error = "Email not found.";
    }
}
?>

<?php include("view/layout/head.php") ?>

<body>
    <div class="container-fluid position-relative d-flex p-0">
        <!-- Log in Start -->
        <div class="container-fluid">
            <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
                <div class="col-12 col-sm-8 col-md-6 col-lg-5 col-xl-4">
                    <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                        <form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post">
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <h3>Login</h3>
                            </div>

                            <?php if ($error): ?>
                                <div class="alert alert-danger"><?php echo $error; ?></div>
                            <?php endif; ?>

                            <div class="form-floating mb-3">
                                <input type="email" class="form-control" id="floatingInput" name="email" placeholder="name@example.com" value="jen@gmail.com"  required>
                                <label for="floatingInput">Email address</label>
                            </div>

                            <div class="form-floating mb-4">
                                <input type="password" class="form-control" id="floatingPassword" name="password" placeholder="Password" value="123" required>
                                <label for="floatingPassword">Password</label>
                            </div>

                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4">Sign In</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Log in End -->
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/chart/chart.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="lib/tempusdominus/js/moment.min.js"></script>
    <script src="lib/tempusdominus/js/moment-timezone.min.js"> </script>
    <script src="lib/tempusdominus/js/tempusdominus-bootstrap-4.min.js"> </script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
</body>
</html>
