<?php
require_once("../site-models/online_orders.class.php");

$item = [];
if (isset($_GET["id"])) {
    $item = ResOnlineOrders::readById($_GET["id"]);
}
?>

<h1>Details of Online Order</h1>
<a href="online-orders" class="btn btn-primary mb-3">Back to Manage</a>

<?php if (!empty($item) && !empty($item['order'])) { ?>
<!-- Order Info -->
<table class="table table-striped mb-4">
  <tr>
    <th>Order ID</th>
    <td><?php echo htmlspecialchars($item['order']['id']); ?></td>
  </tr>
  <tr>
    <th>Customer Name</th>
    <td><?php echo htmlspecialchars($item['order']['name']); ?></td>
  </tr>
  <tr>
    <th>Phone Number</th>
    <td><?php echo htmlspecialchars($item['order']['phone_no']); ?></td>
  </tr>
  <tr>
    <th>Shipping Address</th>
    <td><?php echo htmlspecialchars($item['order']['shipping_address']); ?></td>
  </tr>
  <tr>
    <th>Total Amount</th>
    <td><?php echo number_format($item['order']['total_amount'], 2); ?></td>
  </tr>
  <tr>
    <th>Order Status</th>
    <td>
        <span class="badge bg-info text-dark">
            <?php echo htmlspecialchars($item['order']['order_status']); ?>
        </span>
    </td>
  </tr>
</table>

<!-- Order Items -->
<h3>Ordered Items</h3>
<table class="table table-bordered align-middle">
  <thead class="table-light">
    <tr>
      <th>Menu Item</th>
      <th>Quantity</th>
      <th>Price</th>
      <th>Sub Total</th>
    </tr>
  </thead>
  <tbody>
    <?php if (!empty($item['items'])) { 
        foreach ($item['items'] as $detail) { ?>
        <tr>
          <td><?php echo htmlspecialchars($detail['menu_name']); ?></td>
          <td><?php echo (int)$detail['quantity']; ?></td>
          <td><?php echo number_format($detail['price'], 2); ?></td>
          <td><?php echo number_format($detail['sub_total'], 2); ?></td>
        </tr>
    <?php } } else { ?>
        <tr><td colspan="4" class="text-center text-muted">No items found for this order</td></tr>
    <?php } ?>
  </tbody>
</table>

<?php } else { echo "<p>No data found.</p>"; } ?>
