<?php
require_once("../site-models/online_orders.class.php");

$msg = "";

// Handle Delete
if (isset($_POST['delete_id'])) {
    $id = intval($_POST['delete_id']);
    $msg = ResOnlineOrders::delete($id);
}
?>

<h1>Manage Online Orders</h1>
<?php if (!empty($msg)) { ?>
    <div class="alert alert-info alert-dismissible fade show" role="alert">
        <?php echo htmlspecialchars($msg); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php } ?>

<table class="table table-striped align-middle  ">
    <thead class="table-light">
        <tr class="">
            <th>ID</th>
            <th>Customer</th>
            <th>Phone</th>
            <th>Address</th>
            <th>Total Amount</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $orders = ResOnlineOrders::readAll();
        if ($orders && count($orders) > 0) {
            foreach ($orders as $order) {
                ?>
                <tr>
                    <td><?php echo $order['id']; ?></td>
                    <td><?php echo htmlspecialchars($order['name']); ?></td>
                    <td><?php echo htmlspecialchars($order['phone_no']); ?></td>
                    <td><?php echo htmlspecialchars($order['shipping_address']); ?></td>
                    <td> ৳<?php echo number_format($order['total_amount'], 2); ?></td>
                    <td>
                        <span class="badge bg-warning text-dark">
                            <?php echo htmlspecialchars($order['order_status']); ?>
                        </span>
                    </td>
                    <td class="d-flex gap-2">
                        <!-- Invoice -->
                        <form action="online-orders-details" method="get" class="d-inline">
                            <input type="hidden" name="id" value="<?php echo $order['id']; ?>">
                            <button type="submit" class="btn btn-info btn-sm">Details</button>
                        </form>

                        <!-- Edit -->
                        <form action="online-orders-edit.php" method="get" class="d-inline">
                            <input type="hidden" name="id" value="<?php echo $order['id']; ?>">
                            <button type="submit" class="btn btn-primary btn-sm">Edit</button>
                        </form>

                        <!-- Delete -->
                        <form method="post" class="d-inline"
                              onsubmit="return confirm('Are you sure you want to delete this order?');">
                            <input type="hidden" name="delete_id" value="<?php echo $order['id']; ?>">
                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php
            }
        } else {
            echo "<tr><td colspan='7' class='text-center text-muted'>No online orders found</td></tr>";
        }
        ?>
    </tbody>
</table>
