<?php
require_once("models/orders.class.php");
$msg = "";
$res = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $order_id = $_POST['order_id'];
    $table_id = $_POST['table_id'];
    $total_amount = $_POST['total_amount'];
    $special_request = $_POST['special_request'];
    $order_status_id = $_POST['order_status_id'];
    $obj = new Orders($id, $order_id, $table_id, $total_amount, $special_request, $order_status_id);
    $msg = $obj->update($id);
}
if (isset($_GET['id'])) {
    $res = Orders::readById($_GET['id']);
}

?>
<h1>Edit Orders</h1>
<a href="orders" class="btn btn-primary mb-3">Back to Manage</a>

<?php if($msg) { ?>
<div class="alert alert-info alert-dismissible fade show" role="alert">
  <?php echo $msg; ?>
  <button type="button" class="btn-close" data-dismiss="alert" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<?php } ?>
<?php if(!empty($res)) { ?>
<div class="card">
  <form method="post">
    <div class="card-body">
      <input type="hidden" name="id" value="<?php echo $res['id']; ?>">
      <div class="form-group mb-3">
        <label for="order_id">Order Id</label>
        <input type="text" class="form-control" name="order_id" id="order_id" value="<?php echo htmlspecialchars($res['order_id']); ?>">
      </div>
      <div class="form-group mb-3">
        <label for="table_id">Table Id</label>
        <input type="text" class="form-control" name="table_id" id="table_id" value="<?php echo htmlspecialchars($res['table_id']); ?>">
      </div>
      <div class="form-group mb-3">
        <label for="total_amount">Total Amount</label>
        <input type="text" class="form-control" name="total_amount" id="total_amount" value="<?php echo htmlspecialchars($res['total_amount']); ?>">
      </div>
      <div class="form-group mb-3">
        <label for="special_request">Special Request</label>
        <input type="text" class="form-control" name="special_request" id="special_request" value="<?php echo htmlspecialchars($res['special_request']); ?>">
      </div>
      <div class="form-group mb-3">
        <label for="order_status_id">Order Status Id</label>
        <input type="text" class="form-control" name="order_status_id" id="order_status_id" value="<?php echo htmlspecialchars($res['order_status_id']); ?>">
      </div>
    </div>
    <div class="card-footer">
      <button type="submit" class="btn btn-success">Update</button>
    </div>
  </form>
</div>
<?php } ?>
