<?php
ob_start(); // Start output buffering

include_once("../site-models/table_booking.class.php");
include_once("models/res_table.class.php");

// Handle table assignment
if (isset($_POST['assign_table'], $_POST['booking_id'], $_POST['table_id'])) {
    $bookingId = (int)$_POST['booking_id'];
    $tableId   = (int)$_POST['table_id'];

    // 1. Get table details
    $tableData = ResTable::readById($tableId);
    if ($tableData) {
        // 2. Update table status to Reserved (3)
        $tableObj = new ResTable($tableData['id'], $tableData['name'], $tableData['capacity'], 3);
        $tableObj->update($tableId);

        // 3. Assign table to booking
        TableBooking::assignTable($bookingId, $tableId);

        // Redirect to avoid form resubmission
        header("Location:".$_SERVER['PHP_SELF']);
        exit();
    }
}

// Handle booking deletion
if (isset($_POST['delete_id'])) {
    TableBooking::delete((int)$_POST['delete_id']);
    header("Location:". $_SERVER['PHP_SELF']);
    exit();
}

// Fetch all bookings and tables
$bookings = TableBooking::readAll();
$tables   = ResTable::readAll();
?>

<div class="container-fluid pt-4 px-4">
    <h1 class="mb-4">All Table Reservations</h1>

    <div class="table-responsive">
        <table class="table table-striped align-middle">
            <thead class="table-light">
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Date</th>
                    <th>Time</th>
                    <th>People</th>
                    <th>Message</th>
                    <th>Assign Table</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($bookings)) : ?>
                    <?php foreach ($bookings as $booking) : ?>
                        <tr>
                            <td><?= $booking['id'] ?></td>
                            <td><?= htmlspecialchars($booking['name']) ?></td>
                            <td><?= htmlspecialchars($booking['email']) ?></td>
                            <td><?= htmlspecialchars($booking['phone']) ?></td>
                            <td><?= htmlspecialchars($booking['booking_date']) ?></td>
                            <td><?= htmlspecialchars($booking['booking_time']) ?></td>
                            <td><?= (int)$booking['people'] ?></td>
                            <td><?= htmlspecialchars($booking['message']) ?></td>
                            <td style="min-width:200px;">
                                <form method="post" class="d-flex flex-column gap-1">
                                    <input type="hidden" name="booking_id" value="<?= $booking['id'] ?>">
                                    <select name="table_id" class="form-select form-select-sm w-100" required>
                                        <option value="">-- Select Table --</option>
                                        <?php foreach ($tables as $table) : ?>
                                            <option value="<?= $table['id'] ?>"
                                                <?= ($table['status'] != 'available') ? 'disabled' : '' ?>>
                                                <?= htmlspecialchars($table['name']) ?> (<?= htmlspecialchars($table['status']) ?>)
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <button type="submit" name="assign_table" class="btn btn-success btn-sm mt-1">Assign</button>
                                </form>
                            </td>
                            <td class="d-flex gap-1">
                                <form method="post" class="d-inline"
                                      onsubmit="return confirm('Are you sure you want to delete this booking?');">
                                    <input type="hidden" name="delete_id" value="<?= $booking['id'] ?>">
                                    <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr>
                        <td colspan="10" class="text-center text-muted">No bookings found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
ob_end_flush(); // Send buffered output
?>
