<?php 
require_once("models/res_table.class.php");

$tables = ResTable::readAll();
?>
<h3 class="mb-2">Tables</h3>
<table class="table table-stripped">
    <thead>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($tables as $table){ 
            // Convert numeric status to text and badge class
            if ($table['table_status_id'] == 1) {
                $statusText = "Available";
                $badgeClass = "badge bg-success";
            } elseif ($table['table_status_id'] == 2) {
                $statusText = "Occupied";
                $badgeClass = "badge bg-danger";
            }elseif ($table['table_status_id'] == 3) {
                $statusText = "reserved";
                $badgeClass = "badge bg-info";
            } else {
                $statusText = "Unknown";
                $badgeClass = "badge bg-secondary ";
            }
        ?>
            <tr>
                <td><?php echo $table['id']; ?></td>
                <td><?php echo $table['name']; ?></td>
                <td><span class="<?php echo $badgeClass; ?> "><?php echo $statusText; ?></span></td>
            </tr>
        <?php } ?>
    </tbody>
</table>
