<?php
session_start();


require_once("admin/config/db.php");
require_once("site-models/res_front_menu.class.php");
require_once("site-models/table_booking.class.php");
require_once("site-models/online_orders.class.php");
include_once('site-models/online_order_details.class.php');
include_once("views/layout/head.php");
include_once("views/layout/nav.php");
require_once("admin/config/base.php");


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['book_table'])) {
    $name    = trim($_POST['name']);
    $email   = trim($_POST['email']);
    $phone   = trim($_POST['phone']);
    $date    = $_POST['date'];
    $time    = $_POST['time'];
    $people  = intval($_POST['people']);
    $message = trim($_POST['message']);

    $booking = new TableBooking(
        null,
        $name,
        $email,
        $phone,
        $date,
        $time,
        $people,
        $message
    );

    $bookingResult = $booking->book();
}


$checkoutMessage = '';
$items = [];


$checkoutMessage = '';
$items = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['checkout'])) {
    $name    = $_SESSION['user_name'] ?? '';
    $phone   = $_SESSION['phone'] ?? '';
    $address = $_SESSION['address'] ?? '';

    $items = isset($_POST['cart_data']) ? json_decode($_POST['cart_data'], true) : [];
    $total = $_POST['total_amount'] ?? 0;

    if (empty($items)) {
        $checkoutMessage = "Your cart is empty!";
    } else {
        $order = new ResOnlineOrders(
            null,   
            null,   
            $name, 
            $phone, 
            $address, 
            $total,
            1      
        );

        $checkoutMessage = $order->createOnlineOrder($items);
    }
}



include_once("route.php");
?>

<!-- Footer Section -->
<?php include_once("views/layout/footer.php"); ?>

<!-- Scroll Top -->
<a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
</a>

<!-- Vendor JS Files -->
<?php include_once("views/layout/foot.php"); ?>
