<?php
// Start session and enable error reporting
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include database and customer model
include_once("admin/config/db.php");
include_once("site-models/res_customers.class.php");

// Define frontend/admin base if not already defined
if(!defined('ADMIN_BASE')){
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
    define('ADMIN_BASE', $protocol.$_SERVER['HTTP_HOST']."/respos/admin/");
}

$customer = new ResCustomers();
$error = '';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    // Fetch customer by email
    $custData = $customer->getByEmail($email);

    if ($custData) {
        // Verify hashed password
        if (password_verify($password, $custData['password'])) {
            // Set session variables
            $_SESSION['user_id']    = $custData['id'];
            $_SESSION['user_name']  = $custData['name'];
            $_SESSION['phone']      = $custData['phone'];
            $_SESSION['address']    = $custData['address'];

            // Redirect user to frontend home (or admin)
            header("Location: index.php"); // change to ADMIN_BASE.'index.php' if admin panel
            exit();
        } else {
            $error = "Invalid email or password.";
        }
    } else {
        $error = "Email not found.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            background: #f8f9fa;
        }
        .login-box {
            max-width: 400px;
            width: 100%;
            padding: 30px;
            border-radius: 15px;
            background: #fff;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <div class="login-box">
        <h3 class="text-center mb-4">Login</h3>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="mb-3">
                <label class="form-label">Email</label>
                <input type="email" name="email" class="form-control" value="<?= isset($email) ? htmlspecialchars($email) : '' ?>" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-control" required>
            </div>

            <button type="submit" class="btn btn-success w-100">Login</button>
        </form>

        <p class="text-center mt-3">
            Don't have an account? <a href="register.php">Register here</a>
        </p>
    </div>
</body>
</html>
