<?php
session_start();
include_once("admin/config/db.php"); 
include_once("site-models/res_customers.class.php"); 

$customer = new ResCustomers();
$error = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $customer->name     = $_POST["username"];
    $customer->email    = $_POST["email"];
    $customer->password = $_POST["password"];
    $customer->phone = $_POST["phone"];
    $customer->address  = $_POST["address"];

    $message = $customer->create();

    if ($message === "Registration successful!") {
        $_SESSION["user"] = $customer->name;
        header("Location: index.php"); // redirect to homepage
        exit();
    } else {
        $error = $message;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Register</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
      background: #f8f9fa;
    }
    .register-box {
      max-width: 450px;
      width: 100%;
      padding: 30px;
      border-radius: 15px;
      background: #fff;
      box-shadow: 0 0 20px rgba(0,0,0,0.1);
    }
  </style>
</head>
<body>
  <div class="register-box">
    <h3 class="text-center mb-4">Create Account</h3>

    <?php if ($error): ?>
      <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" action="">
      <div class="mb-3">
        <label class="form-label">Username</label>
        <input type="text" name="username" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Phone</label>
        <input type="text" name="phone" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Shipping Address</label>
        <textarea name="address" class="form-control" rows="3" required></textarea>
      </div>

      <button type="submit" class="btn btn-success w-100">Register</button>
    </form>

    <p class="text-center mt-3">
      Already have an account? <a href="login.php">Login here</a>
    </p>
  </div>
</body>
</html>
