<?php

class ResOnlineOrderDetails {
    public $id;
    public $order_id;
    public $menu_id;
    public $quantity;
    public $price;
    public $sub_total;

    public function __construct($_id, $_order_id, $_menu_id, $_quantity, $_price) {
        $this->id = $_id;
        $this->order_id = $_order_id;
        $this->menu_id = $_menu_id;
        $this->quantity = $_quantity;
        $this->price = $_price;
        $this->sub_total = $_quantity * $_price; // ✅ calculate in PHP
    }

    public function create() {
        global $db;
        $sql = "INSERT INTO res_online_order_details 
                   (order_id, menu_id, quantity, price, sub_total) 
                VALUES (?, ?, ?, ?, ?)";
        
        $stmt = $db->prepare($sql);
        if (!$stmt) {
            return "Prepare failed: " . $db->error;
        }

        $stmt->bind_param("iiidd", 
            $this->order_id, 
            $this->menu_id, 
            $this->quantity, 
            $this->price, 
            $this->sub_total
        );

        if ($stmt->execute()) {
            $this->id = $db->insert_id;
            return $this->id;
        } else {
            return "Query failed: " . $stmt->error;
        }
    }

    public static function readAll() {
        global $db;
        $sql = "SELECT * FROM res_online_order_details";
        $res = $db->query($sql);
        if ($res) {
            return $res->fetch_all(MYSQLI_ASSOC);
        } else {
            return "Query failed: " . $db->error;
        }
    }

    public static function readById($id) {
        global $db;
        $id = (int)$id;
        $sql = "SELECT * FROM res_online_order_details WHERE id = $id";
        $res = $db->query($sql);
        if ($res) {
            return $res->fetch_assoc();
        } else {
            return "Query failed: " . $db->error;
        }
    }

    public function update($id) {
        global $db;
        $sql = "UPDATE res_online_order_details 
                SET order_id=?, menu_id=?, quantity=?, price=?, sub_total=? 
                WHERE id=?";
        
        $stmt = $db->prepare($sql);
        if (!$stmt) {
            return "Prepare failed: " . $db->error;
        }

        $stmt->bind_param("iiiddi", 
            $this->order_id, 
            $this->menu_id, 
            $this->quantity, 
            $this->price, 
            $this->sub_total,
            $id
        );

        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                return "Update successful.";
            } else {
                return "No changes made or record not found.";
            }
        } else {
            return "Update failed: " . $stmt->error;
        }
    }

    public static function delete($id) {
        global $db;
        $sql = "DELETE FROM res_online_order_details WHERE id = ?";
        $stmt = $db->prepare($sql);
        if (!$stmt) {
            return "Prepare failed: " . $db->error;
        }

        $stmt->bind_param("i", $id);

        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                return "Delete successful.";
            } else {
                return "No record found with ID $id.";
            }
        } else {
            return "Delete failed: " . $stmt->error;
        }
    }
}
