<?php
class TableBooking {
    public $id;
    public $name;
    public $email;
    public $phone;
    public $date;
    public $time;
    public $people;
    public $message;

    // Constructor
    public function __construct($_id, $_name, $_email, $_phone, $_date, $_time, $_people, $_message) {
        $this->id      = $_id;
        $this->name    = $_name;
        $this->email   = $_email;
        $this->phone   = $_phone;
        $this->date    = $_date;
        $this->time    = $_time;
        $this->people  = $_people;
        $this->message = $_message;
    }

    public function book() {
        global $db; 

        $sql = "
            INSERT INTO bookings (name, email, phone, booking_date, booking_time, people, message)
            VALUES ('$this->name', '$this->email', '$this->phone', '$this->date', '$this->time', $this->people, '$this->message')
        ";

        if ($db->query($sql)) {
            echo "
            <script>
            Swal.fire({
              icon: 'success',
              title: 'Booking Successful!',
              text: 'Thank You For Dining With Us!',
              confirmButtonText: 'OK'
            });
            </script>
            ";
        } else {
            echo '<script>alert("Error: ' . $db->error . '");</script>';
        }
    }

    public static function readAll() {
        global $db;

        $sql = "SELECT id, name, email, phone, booking_date, booking_time, people, message, table_id 
                FROM bookings 
                ORDER BY booking_date DESC, booking_time DESC";

        $res = $db->query($sql);

        return $res ? $res->fetch_all(MYSQLI_ASSOC) : [];
    }

    public static function assignTable($bookingId, $tableId) {
        global $db;

        // Update the table's status to Reserved (3)
        $statusReserved = 3;
        $stmt = $db->prepare("UPDATE res_tables SET table_status_id = ? WHERE id = ?");
        $stmt->bind_param("ii", $statusReserved, $tableId);
        $tableUpdated = $stmt->execute();

        // Update booking with assigned table
        $stmt2 = $db->prepare("UPDATE bookings SET table_id = ? WHERE id = ?");
        $stmt2->bind_param("ii", $tableId, $bookingId);
        $bookingUpdated = $stmt2->execute();

        return $tableUpdated && $bookingUpdated;
    }

    // Delete booking
    public static function delete($bookingId) {
        global $db;

        // Optional: reset table status if table was assigned
        $stmt = $db->prepare("SELECT table_id FROM bookings WHERE id = ?");
        $stmt->bind_param("i", $bookingId);
        $stmt->execute();
        $stmt->bind_result($tableId);
        $stmt->fetch();
        $stmt->close();

        if ($tableId) {
            $availableStatus = 1; // assuming 1 = available
            $stmt2 = $db->prepare("UPDATE res_tables SET table_status_id = ? WHERE id = ?");
            $stmt2->bind_param("ii", $availableStatus, $tableId);
            $stmt2->execute();
            $stmt2->close();
        }

        // Delete booking
        $stmt3 = $db->prepare("DELETE FROM bookings WHERE id = ?");
        $stmt3->bind_param("i", $bookingId);
        $result = $stmt3->execute();
        $stmt3->close();

        return $result;
    }
}

?>
