<!-- Cart Section -->
<main id="main" class="mt-5 pt-5">

  <section class="container">
    <h2 class="text-center mb-4">My Cart</h2>

    <!-- Cart Table -->
    <div class="table-responsive">
      <table class="table table-bordered w-100 table-sm">
        <thead class="table-danger">
          <tr>
            <th style="padding: 15px;">Item</th>
            <th style="padding: 15px;">Price</th>
            <th style="padding: 15px;">Quantity</th>
            <th style="padding: 15px;">Total</th>
            <th style="padding: 15px;">Action</th>
          </tr>
        </thead>
        <tbody id="cart-items">
          <tr>
            <td colspan="5" class="text-center py-4">Cart is empty</td>
          </tr>
        </tbody>
      </table>
    </div>

    <!-- Cart Summary + Checkout -->
    <div class="d-flex justify-content-between align-items-center mt-4">
      <h4>Total: ৳ <span id="cart-total">0.00</span></h4>
      <form action="checkout.php" method="POST" id="checkout-form">
        <input type="hidden" name="cart_data" id="cart-data">
        <input type="hidden" name="total_amount" id="total-amount">
        <button type="submit" class="btn btn-success btn-lg">Proceed to Checkout</button>
      </form>
    </div>
  </section>

</main>

<script>
  document.addEventListener("DOMContentLoaded", () => {
    const cartCountEl = document.getElementById("cart-count");
    const cartItemsEl = document.getElementById("cart-items");
    const cartTotalEl = document.getElementById("cart-total");

    // Render Cart
    function renderCart() {
      const cart = cartHelper.getCart();
      cartItemsEl.innerHTML = "";

      if (cart.length === 0) {
        cartItemsEl.innerHTML = '<tr><td colspan="5" class="text-center py-4">Cart is empty</td></tr>';
        cartTotalEl.textContent = "0.00";
        if (cartCountEl) cartCountEl.textContent = "0";
        return;
      }

      let total = 0;
      cart.forEach(item => {
        const discountedPrice = item.price - (item.discount || 0);
        const itemTotal = discountedPrice * item.quantity;
        total += itemTotal;

        const row = document.createElement("tr");
        row.innerHTML = `
          <td style="padding: 12px;">${item.name}</td>
          <td style="padding: 12px;">${discountedPrice.toFixed(2)}</td>
          <td style="padding: 12px;">
            <div class="d-flex justify-content-center align-items-center">
              <button class="btn btn-sm btn-danger decrease-qty me-2" data-id="${item.id}">-</button>
              <span class="mx-2 qty-text">${item.quantity}</span>
              <button class="btn btn-sm btn-success increase-qty ms-2" data-id="${item.id}">+</button>
            </div>
          </td>
          <td style="padding: 12px;">${itemTotal.toFixed(2)}</td>
          <td style="padding: 12px;">
            <button class="btn btn-sm btn-danger remove-item" data-id="${item.id}">Remove</button>
          </td>
        `;
        cartItemsEl.appendChild(row);
      });

      cartTotalEl.textContent = total.toFixed(2);
      if (cartCountEl) {
        cartCountEl.textContent = cart.reduce((sum, i) => sum + i.quantity, 0);
      }
    }

    // Initial Render
    renderCart();

    // Cart Actions
    cartItemsEl.addEventListener("click", e => {
      const target = e.target;

      if (target.classList.contains("increase-qty")) {
        const id = parseInt(target.dataset.id);
        cartHelper.increaseQuantity(id);
        renderCart();
      }

      if (target.classList.contains("decrease-qty")) {
        const id = parseInt(target.dataset.id);
        cartHelper.decreaseQuantity(id);
        renderCart();
      }

      if (target.classList.contains("remove-item")) {
        const id = parseInt(target.dataset.id);
        cartHelper.removeItem(id);
        renderCart();
      }
    });

    // Add to cart buttons
    document.querySelectorAll(".add-to-cart-btn").forEach(btn => {
      btn.addEventListener("click", e => {
        e.preventDefault();
        const id = parseInt(btn.dataset.id);
        const name = btn.dataset.name;
        const price = parseFloat(btn.dataset.price);
        cartHelper.addItem(id, name, price, 1);
        renderCart();
      });
    });

    // Checkout form submission → send cart data
    const checkoutForm = document.getElementById("checkout-form");
    checkoutForm.addEventListener("submit", function () {
      const cart = cartHelper.getCart();
      document.getElementById("cart-data").value = JSON.stringify(cart);
      document.getElementById("total-amount").value = document.getElementById("cart-total").textContent;
    });
  });







  const checkoutFormModal = document.getElementById("checkout-form-modal");

checkoutFormModal.addEventListener("submit", function(e) {
    const cart = cartHelper.getCart(); // get current cart items
    if (cart.length === 0) {
        e.preventDefault();
        alert("Your cart is empty!");
        return;
    }

    // Fill hidden inputs
    document.getElementById("cart-data-modal").value = JSON.stringify(cart);
    document.getElementById("total-amount-modal").value = cart.reduce((sum, item) => {
        const discountedPrice = item.price - (item.discount || 0);
        return sum + discountedPrice * item.quantity;
    }, 0).toFixed(2);
});

</script>
