<section id="menu" class="menu section">

    <!-- Section Title -->
    <div class="container section-title" data-aos="fade-up">
        <h2>Our Menu</h2>
        <p><span>Check Our</span> <span class="description-title">Yummy Menu</span></p>
    </div>

    <div class="container">

        <!-- Tabs -->
        <ul class="nav nav-tabs d-flex justify-content-center" data-aos="fade-up" data-aos-delay="100">
            <?php 
            $tabs = ['Starters', 'Pizza', 'Main Course', 'Soft Drinks'];
            $tabIds = ['menu-starters', 'menu-breakfast', 'menu-lunch', 'menu-dinner'];
            foreach ($tabs as $index => $tabName): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo $index === 0 ? 'active show' : '' ?>" 
                       data-bs-toggle="tab" 
                       data-bs-target="#<?php echo $tabIds[$index]; ?>">
                        <h4><?php echo $tabName; ?></h4>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>

        <!-- Tab Contents -->
        <div class="tab-content" data-aos="fade-up" data-aos-delay="200">
            <?php
            $menuFunctions = ['menuByStarter', 'menuByPizza', 'menuByMainCourse', 'menuBySoftDrinks'];

            foreach ($menuFunctions as $index => $func):
                $items = ResMenu::$func(); // call dynamic function
            ?>
                <div class="tab-pane fade <?php echo $index === 0 ? 'active show' : '' ?>" id="<?php echo $tabIds[$index]; ?>">
                    <div class="tab-header text-center">
                        <p>Menu</p>
                        <h3><?php echo $tabs[$index]; ?></h3>
                    </div>

                    <div class="row gy-5">
                        <?php foreach ($items as $menu): ?>
                            <div class="col-lg-4 menu-item">
                                <a href="assets/img/menu/menu-item-1.png" class="glightbox">
                                    <img src="admin/<?php echo $menu['photos']; ?>" class="menu-img img-fluid" alt="">
                                </a>
                                <h4><?php echo $menu['name']; ?></h4>
                                <p class="ingredients"><?php echo $menu['category']; ?></p>
                                <p class="price">৳<?php echo $menu['price']; ?></p>
                                <p class="add-to-cart">
                                    <?php if (isset($_SESSION['user_id'])): ?>
                                        <a href="#" class="btn btn-outline-secondary btn-transition add-to-cart-btn"
                                           data-id="<?php echo $menu['id']; ?>"
                                           data-name="<?php echo htmlspecialchars($menu['name']); ?>"
                                           data-price="<?php echo $menu['price']; ?>">
                                           <i class="fa-solid fa-cart-plus" style="color: #B197FC;"></i> Add to Cart
                                        </a>
                                    <?php else: ?>
                                        <a href="login.php" class="btn btn-outline-secondary btn-transition">
                                           <i class="fa-solid fa-right-to-bracket"></i> Login to Add
                                        </a>
                                    <?php endif; ?>
                                </p>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

    </div>

</section>
